/*
  system log sender (smtp/icq/file)
  written by alexander yaworsky
  '99
*/

#include <excpt.h>
#include <windows.h>

#include "stringlist.h"
#include "syslogsender.h"
#include "network.h"
#include "paths.h"
#include "stdlib.h"
#include "syslog.h"
#include "switches.h"


//#define TEST


#define SMTP_USERNAME_MAX      128
#define SMTP_DOMAIN_MAX        128
#define SMTP_PATH_MAX          512
#define SMTP_COMMANDLINE_MAX  1024
#define SMTP_REPLYLINE_MAX    1024
#define SMTP_TEXTLINE_MAX     2048
#define SMTP_RECIPIENTS_MAX    256


static void GetHostAddress()
  {
    char     Hostname[ 100 ];
    HOSTENT  *HEnt;
    int      i;
    ULONG    Addr;
    char     Buf[ 4096 ];

    gethostname( Hostname, sizeof( Hostname ) );
    HEnt = gethostbyname( Hostname );
    lstrcpy( Buf, "IP address list:" );
    for( i = 0; HEnt->h_addr_list[ i ]; i++ ) {
      Addr = *((ULONG*) HEnt->h_addr_list[ i ]);
      wsprintf( Buf + lstrlen( Buf ), "  %d.%d.%d.%d", Addr & 255,
                (Addr >> 8) & 255, (Addr >> 16) & 255, (Addr >> 24) & 255 );
    }
    SysLog( Buf );
  }


static int ReceiveLine( void* Ctx, char* Buf, int BufSz )
/*
  Receives data until LF reached (not passed in Buf). If Buf not
  large enough then the rest of data discarded.
  Returns 0 - ok, negative value - severe error,
  positive value - line truncated.
  Note: CR characters are removed.
*/
  {
    int   Idx, RetVal;

    RetVal = 0;
    Buf[ 0 ] = '\0';
    for( Idx = 0;; ) {
      if( ! RecvData( Ctx, &Buf[ Idx ], 1 ) ) return -1;
      if( Buf[ Idx ] != '\r' ) {
        if( Buf[ Idx ] == '\n' ) {
          Buf[ Idx ] = '\0';
          break;
        }
        Idx++; if( Idx == BufSz ) { RetVal = 1; Idx--; Buf[ Idx ] = '\0'; }
      }
    }
    return RetVal;
  }

static BOOL SMTPWaitReply( void* Ctx )
/*
  Waits a reply.
  Returns TRUE - ok, FALSE - error or bad reply.
*/
  {
    char  ReplyBuf[ SMTP_REPLYLINE_MAX ];

    if( ReceiveLine( Ctx, ReplyBuf, SMTP_REPLYLINE_MAX ) < 0 )
      return FALSE;
#   ifdef TEST
      SysLog( "SMTPWaitReply: received %s", ReplyBuf );
#   endif
    if( ReplyBuf[0] != '1' && ReplyBuf[0] != '2' && ReplyBuf[0] != '3' )
      return FALSE;
    return TRUE;
  }

static BOOL SMTPSendCommand( void* Ctx, char* Command )
/*
  Sends command to SMTP host and calls WaitReply.
  Returns TRUE - ok, FALSE - error or bad reply.
*/
  {
    if( ! SendData( Ctx, Command, strlen( Command ) ) != 0 ) return FALSE;
    if( ! SendData( Ctx, "\r\n", 2 ) != 0 ) return FALSE;
#   ifdef TEST
      SysLog( "SMTPSendCommand: sent %s", Command );
#   endif
    return SMTPWaitReply( Ctx );
  }

static BOOL SMTPSender( char* Recipient, char* Address,
                        STRINGLIST* Log, DWORD Index )
  {
    void*   Ctx;
    char    Addr[ 128 ];
    char    Port[ 16 ];
    char    Command[ SMTP_COMMANDLINE_MAX ];
    char    *cp;
    BOOL    Rc;

    if( Recipient == NULL || Address == NULL ) {
      SysLog( "SMTPSender: Recipient and/or Address are NULLs" );
      return FALSE;
    }
    if( *Recipient == '\0' || *Address == '\0' ) {
      SysLog( "SMTPSender: Recipient and/or Address are not specified" );
      return FALSE;
    }
    Ctx = AllocateContext( PROTOCOL_TCP );
    if( Ctx == NULL ) {
      SysLog( "SMTPSender: AllocateContext failed" );
      return FALSE;
    }
    SetLocalPort( Ctx, NULL );
    lstrcpy( Addr, Address );
    if( (cp = Strchr( Addr, ':' )) != NULL ) *cp = '\0';
    SetPeerAddress( Ctx, Addr, (cp != NULL)? cp : "25" );
    Rc = FALSE;
    if( ! OpenPort( Ctx ) )
      SysLog( "SMTPSender: OpenPort failed" );
    else {
      if( ! EstablishConnection( Ctx ) )
        SysLog( "SMTPSender: EstablishConnection with %s failed", Address );
      else {
        Addr[0] = '\0';
        Command[0] = '\0';
        GetLocalAddress( Ctx, Addr, Port );
        if( ! SMTPWaitReply( Ctx ) ) goto quit;
        wsprintf( Command, "HELO [%s]", Addr );
        if( ! SMTPSendCommand( Ctx, Command ) ) goto quit;
        wsprintf( Command, "MAIL FROM:<%s@%s>", Port, Addr );
        if( ! SMTPSendCommand( Ctx, Command ) ) goto quit;
        wsprintf( Command, "RCPT TO:<%s>", Recipient );
        if( ! SMTPSendCommand( Ctx, Command ) ) goto quit;
        if( ! SMTPSendCommand( Ctx, "DATA" ) ) goto quit;

        // because system log entries never contain period first, don't care

        for( ; Index < Log->Count; Index++ ) {
          if( ! SendData( Ctx, Log->Value[ Index ],
                          lstrlen( Log->Value[ Index ] ) ) ) goto quit;
          if( ! SendData( Ctx, "\r\n", 2 ) ) goto quit;
        }

        if( ! SMTPSendCommand( Ctx, "\r\n." ) ) goto quit;
        Rc = TRUE;
  quit:
        SMTPSendCommand( Ctx, "QUIT" );
      }
      ClosePort( Ctx );
    }
    DeallocateContext( Ctx );
    return Rc;
  }

static BOOL ICQSender( char* Recipient, char* Address,
                       STRINGLIST* Log, DWORD Index )
  {
    return FALSE;
  }

static BOOL FILESender( char* Recipient, char* Address,
                        STRINGLIST* Log, DWORD Index )
  {
    HANDLE  Fh;
    DWORD   s;
    char    FileName[ MAX_PATH ];
    static  char    Separator[] = "\r\n\r\n\r\n\r\n****** System log ******************************\r\n\r\n";

    if( Recipient == NULL ) {
      SysLog( "FILESender: Recipient is NULL" );
      return FALSE;
    }
    if( *Recipient == '\0' ) {
      SysLog( "FILESender: Recipient is not specified" );
      return FALSE;
    }
    if( Address == NULL ) GetAnyPath( FileName, Recipient );
    else if( *Address == '\0' ) GetAnyPath( FileName, Recipient );
    else {
      lstrcpy( FileName, Address );
      if( FileName[ lstrlen( FileName ) - 1 ] != Slash[0] )
        lstrcat( FileName, Slash );
      lstrcat( FileName, Recipient );
    }
    Fh = CreateFile( FileName, GENERIC_READ | GENERIC_WRITE,
                     0, NULL, OPEN_ALWAYS, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) {
      SysLog( "FILESender: CreateFile( %s ) failed, error %d",
              FileName, GetLastError() );
      return FALSE;
    }
    if( SetFilePointer( Fh, 0, NULL, FILE_END ) != 0 )
      WriteFile( Fh, Separator, lstrlen( Separator ), &s, NULL );

    for( ; Index < Log->Count; Index++ ) {
      WriteFile( Fh, Log->Value[ Index ],
                 lstrlen( Log->Value[ Index ] ), &s, NULL );
      WriteFile( Fh, "\r\n", 2, &s, NULL );
    }
    CloseHandle( Fh );
    return TRUE;
  }

BOOL SendSysLog( char* Recipient, char* Address, DWORD HowMany )
  {
    char   Rcpt[ 64 ];
    DWORD  i;
    BOOL   Rc;
    STRINGLIST  Log;
    WSADATA     WsaData;

    if( Recipient == NULL ) {
      SysLog( "SendSysLog: Recipient is NULL" );
      return TRUE;
    }
    if( *Recipient == '\0' ) {
      SysLog( "SendSysLog: Recipient is not specified" );
      return TRUE;
    }

    if( WSAStartup( MAKEWORD( 1, 1 ), &WsaData ) != 0 ) {
      SysLog( "SendSysLog: WSAStartup failed, error %d", WSAGetLastError() );
      return FALSE;
    }
    Rc = FALSE;
    _try {
      _try {
        GetHostAddress();
      }
      _except( EXCEPTION_EXECUTE_HANDLER ) {
        SysLog( "SendSysLog: GetHostAddress caused an exception %08X", GetExceptionCode() );
      }
      InitStringList( &Log );
      ExtractSysLog( 0, &Log );
      if( HowMany <= 0 || HowMany > Log.Count ) i = 0;
      else i = Log.Count - HowMany;

      lstrcpy( Rcpt, Recipient );
      Rcpt[ 4 ] = '\0';
      if( lstrcmpi( Rcpt, "ICQ:" ) == 0 )
        Rc = ICQSender( Recipient + 4, Address, &Log, i );
      else {
        lstrcpy( Rcpt, Recipient );
        Rcpt[ 5 ] = '\0';
        if( lstrcmpi( Rcpt, "FILE:" ) == 0 )
          Rc = FILESender( Recipient + 5, Address, &Log, i );
        else
          Rc = SMTPSender( Recipient, Address, &Log, i );
      }
      FreeStringList( &Log );
    }
    _finally {
      WSACleanup();
    }
    return Rc;
  }
